Imports System.Collections

Public Class RecordFactory
    Private creators As Hashtable

    ' Konstruktor
    Public Sub New()
        creators = New Hashtable()
        creators("ETH") = New EthCreator()
        creators("SS1") = New Ss1Creator()
    End Sub

    ' Tworzy i zwraca egzemplarz konkretnej podklasy klasy RecordObject.
    ' Wybr waciwej podklasy zaley od przekazanego na wejciu typu
    ' rekordu (reprezentowanego w acuchu tego rekordu).
    Public Function createRecord(ByVal recordString As String) As RecordObject
        ' Uzyskuje typ rekordu.
        Dim i As Integer = recordString.IndexOf(":"c)
        If i < 1 Then
            Throw New System.ApplicationException(recordString)
        End If
        Dim recordType As String = recordString.Substring(0, i)

        ' Tworzy obiekt klasy RecordObject.
        Dim creator As IRecordCreator
        creator = CType(creators(recordType), IRecordCreator)
        If creator Is Nothing Then
            Throw New System.ApplicationException(recordType)
        End If
        Return creator.Create(recordString)
    End Function 'createRecord
End Class 'RecordFactory
